define(['angular', 'app'], function (angular, app) {
	app.constant("FitnessConstants", {
		'fitnessActivities': {
			summary: {
				table : {
					columns : [
						{label: 'Activity', keys: 'component[3].valueString', class: {column: 'hidden-xs'}},
						{label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/fitness/pages/summary/partials/_date-time.html' },
						{label: 'Duration (min)', keys: 'component[0].valueQuantity.value', class: {column: 'hidden-xs'}},
						{label: 'Distance (miles)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
						{label: 'steps', keys: 'extension[1].valueString', class: {column: 'hidden-xs'}},
						{label: 'Intensity', keys: 'component[2].valueString', class: {column: 'hidden-xs'}},
						{label: 'Note', keys: 'comments', cellTemplate: 'src/modules/fitness/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } },
					]
				}
			},
			entry: {
				entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-activity.html',

				vitalObservationsMeta:[
					{
						name : 'minutes',
						label : 'Duration',
						units : 'minutes',
						min : '0',
						max : '1440',
						validationExpression : /(^0$)|(^[1-9][0-9]{0,3}$)/,
						userInputPattern : /^[0-9]{0,4}$/
					},
					{
						name : 'miles',
						label : 'Distance',
						units : 'miles',
						min : '0.1',
						max : '50000',
						validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
						userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
					}
				],
				steps : {
					name : 'steps',
					label : 'Distance',
					units : 'steps',
					min : '0.1',
					max : '50000',
					validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
					userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
				},
				intensity: {
					label: 'Exercise Intensity',
					options: ['Very Easy', 'Easy', 'Somewhat Easy', 'Somewhat Hard', 'Hard', 'Very Hard']
				},
				exerciseactivity: {
					label: 'Exercise Activity',
					options: ['Walking', 'Running', 'Cycling', 'Swimming', 'Dancing', 'Tennis', 'Hiking', 'Strength Exercise', 'Housework', 'Gardening', 'Golf', 'Yoga', 'Rowing', 'Stairs', 'Sports', 'General Calisthenics', 'Other']
				},
			},
			name: 'Fitness Activity'
		},
		'goalHistory' : {
			summary : {
				table : {
					columns : [
						{id: 'id', keys: 'id', class: {column: 'hidden-xs'}},
						{label: 'Date/Time', keys: 'startDate', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
						{label: 'Progress/Goal', keys: 'summary', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html' },
						{label: 'Met?',keys:'met'}
					]
				}
			}
		},
		'fitness-activity': {
			summary: {
				table : {
					columns : [
						{label: 'Activity', keys: 'component[3].valueString', class: {column: 'hidden-xs'}},
						{label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html'},
						{label: 'Duration (min)', keys: 'component[0].valueQuantity.value', class: {column: 'hidden-xs'}},
						{label: 'Distance (miles)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
						{label: 'Steps', keys: 'extension[1].valueString', class: {column: 'hidden-xs'}},
						{label: 'Intensity', keys: 'component[2].valueString', class: {column: 'hidden-xs'}},
						{label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } },

					]
				}
			},
			entry: {
				entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-activity.html',

				vitalObservationsMeta:[
					{
						name : 'minutes',
						label : 'Duration',
						units : 'minutes',
						min : '0',
						max : '1440',
						validationExpression : /(^0$)|(^[1-9][0-9]{0,3}$)/,
						userInputPattern : /^[0-9]{0,4}$/
					},
					{
						name : 'miles',
						label : 'Distance',
						units : 'miles',
						min : '0.1',
						max : '50000',
						validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
						userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
					}
				],
				steps : {
					name : 'steps',
					label : 'Distance',
					units : 'steps',
					min : '0.1',
					max : '50000',
					validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
					userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
				},
				intensity: {
					label: 'Exercise Intensity',
					options: ['Very Easy', 'Easy', 'Somewhat Easy', 'Somewhat Hard', 'Hard', 'Very Hard']
				},
				exerciseactivity: {
					label: 'Exercise Activity',
					options: ['Walking', 'Running', 'Cycling', 'Swimming', 'Dancing', 'Tennis', 'Hiking', 'Strength Exercise', 'Housework', 'Gardening', 'Golf', 'Yoga', 'Rowing', 'Stairs', 'Sports', 'General Calisthenics', 'Other']
				},
			},
			name: 'Fitness Activity'
		},
		'fitness-goals': {
			summary: {
				table : {
					columns : [
						{label: 'Date Entered', keys: 'activityDate'},
						{label: 'Activity', keys: 'type'},
						{label: 'Duration (min)', keys: 'value.minutes', class: {column: 'hidden-xs'}},
						{label: 'Steps', keys: 'value.steps', class: {column: 'hidden-xs'}},
						{label: 'Distance (miles)', keys: 'value.miles', class: {column: 'hidden-xs'}},
						{label: 'Intensity', keys: 'intensity', class: {column: 'hidden-xs'}}
					]
				}
			},
			entry: {
				entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-goals.html',
				intensity: {
					label: 'Exercise Intensity',
					options: ['Very Easy', 'Easy', 'Somewhat Easy', 'Somewhat Hard', 'Hard', 'Very Hard']
				},
				exerciseactivity: {
					label: 'Exercise Activity',
					options: ['Walking', 'Running', 'Cycling', 'Swimming', 'Dancing', 'Tennis', 'Hiking', 'Strength Exercise', 'Housework', 'Gardening', 'Golf', 'Yoga', 'Rowing', 'Stairs', 'Sports', 'General Calisthenics', 'Other']
				},
				vitalObservationsMeta:[
					{
						name : 'minutes',
						label : 'Duration (minutes)',
						min : '0',
						max : '10080',
						validationExpression : /(^0$)|(^[1-9][0-9]{0,4}$)/,
						userInputPattern : /^[0-9]{0,5}$/
					},
					{
						name : 'steps',
						label : 'Distance (steps)',
						min : '0',
						max : '50000',
						validationExpression : /(^0$)|(^[1-9][0-9]{0,4}$)/,
						userInputPattern : /^[0-9]{0,5}$/
					},
					{
						name : 'miles',
						label : 'Distance (miles)',
						min : '0.1',
						max : '50000',
						validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
						userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
					}
				]
			}
		}
	});
});